Include([[Data/levels/include/level_utils.lua]])

function SendHunters(p_humanPtr)

    local startEnt = GameWorld:GetZombieAttackSpawnEntity(2, p_humanPtr:GetPos(), false)
    if startEnt == nil  then
        return
    end
    
    local alienCount = 3
    for i=1,alienCount do
        local offsetDelta = vect2f.MakePolar(GetRandomRange(3.0, 4.0), i/alienCount*math.pi*2)
        local alienMarine = GameWorld:CreateEntity("InfestedMarine", "", startEnt:GetPos() + offsetDelta)
        alienMarine:SetSpeedMultiple(2.0)
        alienMarine:SetDegeneration(false)
        
        alienMarine:CommandFocusAttack(p_humanPtr, p_humanPtr:GetPos())
    end   

end

ScriptMgr:DoImmideateLoopedCall(50000, 
    function()
    
        local huntersSent = false
        local entCount = GameWorld:GetEntityCount()
        for i=0,entCount-1 do
            local ent = GameWorld:GetEntityByIndex(i)
            
            if ent then
                local human = ent:ToCHuman()
            
                if  human and
                    human:GetIsPlayerControlled() and
                    human:GetWeaponType() == WeaponType.WT_MEDIC then
                    
                    huntersSent = true
                    SendHunters(human)
                end
            end
        end
        
        if huntersSent then
            GameWorld:AddNotice("Hunter Attack Imminent", true)
            AudioEngine.ReportAudioEvent([[SpecialAttackWarning]])
        end

        return true                                       
    end)

------------------------------------------------------------------------------- Mutation has been turned off!
MutationWatcher = LevelUtils.MakeGoal(
	function (self)
	end,
	
	{[[NT_MUTATION_DEACTIVATED]]},
	function (self, p_type, p_entId, p_pos, p_other)	
		
        if p_other == [[ZU_MARTYRDOM]] then
            ScriptMgr:TerminateScript()
        end
		
	end)
MutationWatcher:Enable()